#include <iostream>
#include <vector>
#include <algorithm>

struct Runner {
    int position;
    int speed;
};

bool compareRunners(const Runner& a, const Runner& b) {
    return a.position < b.position;
}

double timeToOvertake(const Runner& a, const Runner& b) {
    return static_cast<double>(b.position - a.position) / (a.speed - b.speed);
}

int main() {
    int N, K;
    std::cin >> N >> K;

    std::vector<Runner> runners(N);
    for (int i = 0; i < N; ++i) {
        std::cin >> runners[i].position >> runners[i].speed;
    }

    std::sort(runners.begin(), runners.end(), compareRunners);

    double time = 0.0;
    for (int i = 0; i < N - 1; ++i) {
        for (int j = i + 1; j < N; ++j) {
            double t = timeToOvertake(runners[i], runners[j]);
            if (t > time) {
                time = t;
            }
        }
    }

    std::cout << time << std::endl;

    return 0;
}